#!/usr/bin/env python
# Set Plan Bar Color By Resource.py
# Copyright 2005, 2006 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 050627 - Set the PlanBarColor in the report row based on same column in Resource
# 051203 - Alexander - test for basestring before uppercase conversion (instead of str)
# 060310 - Brian - if multiple resource colors on task, use average

import wx
import re

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

if debug: print 'Start Script'


def SetPlanBarColor(self):

    # set local pointers to tables
    rid = self.ReportID  # current report
    drep = Data.Database['Report']
    drow = Data.Database['ReportRow']
    drt = Data.Database['ReportType']
    dt = Data.Database['Task']
    da = Data.Database['Assignment']
    dres = Data.Database['Resource']
    rr = drep[rid]

    # make sure report has report type
    if not rr.has_key('ReportTypeID') or not drt.has_key(rr['ReportTypeID']): 
        if debug: print "ReportType key not found"
        hint("Error: Can't find type of this report.")
        return
    rtid = rr['ReportTypeID']

    # is this a task report
    rt = drt[rtid] # pointer to report type record
    ta = rt.get('TableA')
    tb = rt.get('TableB')  # if two table report all inserts go at the end (less confusing to user)
    if not (ta == 'Task' or tb == 'Task'):
        hint('Use script only with Task reports.')
        return

    # update all visible rows
    rows = self.Report.table.rows  # all visible rows in display order
    # get row ids for all task rows
    rids = [ x for x in rows if drow[x].get('TableName') == 'Task' ]

    # set color for each selected row based on color of assigned resource
    for rowid in rids:
        # get task id
        tid = drow[rowid].get("TableID")
        if not tid or not dt.has_key(tid): continue  # silently skip invalid rows

        # look up assigned resources
        resids = [ da[x].get('ResourceID') for x in da.keys() 
            if da[x].get('TaskID') == tid and da[x].get('zzStatus') != 'deleted' ]

        # look up resource colors
        colors = [ dres[x].get("PlanBarColor") for x in resids if dres.has_key(x) and dres[x].get('zzStatus') != 'deleted' ]

        # make sure some results found
        if len(colors) == 0:  # no assigned resource records
            newcolor = None
        else:
            # are all colors the same
            same = colors.count(colors[0])  # how many are the same as the first one?
            # hint("Same" + str(same) + ", " + str(len(colors)))
            if len(colors) == same:  # all of them?
                newcolor = colors[0]
            else:
                colors = [ 
                    (int(x[0:2],16),
                     int(x[2:4],16), 
                     int(x[4:6],16))
                     for x in colors if re.match('^[0-9A-Fa-f]{6}$', x) ]
                cnt = len(colors)
                if cnt:
                    r = g = b = 0
                    for rr, gg, bb in colors:
                        r += rr; g += gg; b += bb
#                   r %= 256; g %= 256; b %= 256
                    r //= cnt; g //= cnt; b //= cnt
                    newcolor = "%02x%02x%02x" % (r, g, b)
                else:
                    newcolor = None

        if isinstance(newcolor, basestring): newcolor = newcolor.upper()  # set to uppercase hex
        if not (newcolor == None or re.match('^[0-9A-F]{6}$', newcolor)):  # skip invalid colors
            continue

        # change row to new color
        if drow[rowid].get('PlanBarColor') != newcolor:
            change = { 'Table': 'ReportRow', 'ID': rowid, 'PlanBarColor': newcolor }
            Data.Update(change)

    Data.SetUndo('Set Plan Bar Color By Resource')


SetPlanBarColor(self)

if debug: print 'End Script'

